<?php

declare(strict_types=1);

use App\Core\JsonStorage;

session_start();

require __DIR__ . '/src/bootstrap.php';

$config = require __DIR__ . '/config/config.php';

$password = (string) ($config['admin_password'] ?? '');

if ($password === '') {
    echo 'Admin password is not configured.';
    exit;
}

if (isset($_POST['logout'])) {
    $_SESSION = [];
    if (ini_get('session.use_cookies')) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000, $params['path'], $params['domain'], $params['secure'], $params['httponly']);
    }
    session_destroy();
    header('Location: admin.php');
    exit;
}

$loggedIn = isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
$error = '';

if (!$loggedIn && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['password'])) {
    $input = (string) $_POST['password'];
    if (hash_equals($password, $input)) {
        $_SESSION['admin_logged_in'] = true;
        header('Location: admin.php');
        exit;
    }
    $error = 'رمز عبور اشتباه است.';
    $loggedIn = false;
}

if (!$loggedIn) {
    ?>
    <!DOCTYPE html>
    <html lang="fa">
    <head>
        <meta charset="UTF-8">
        <title>ورود ادمین ربات</title>
        <style>
            body { font-family: sans-serif; background-color: #f5f5f5; direction: rtl; }
            .container { max-width: 400px; margin: 100px auto; background: #fff; padding: 24px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); }
            .field { margin-bottom: 16px; }
            label { display: block; margin-bottom: 4px; }
            input[type="password"] { width: 100%; padding: 8px; box-sizing: border-box; }
            button { padding: 8px 16px; }
            .error { color: #b00020; margin-bottom: 8px; }
        </style>
    </head>
    <body>
    <div class="container">
        <h1>ورود پنل ادمین</h1>
        <?php if ($error !== ''): ?>
            <div class="error"><?php echo htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
        <?php endif; ?>
        <form method="post">
            <div class="field">
                <label for="password">رمز عبور</label>
                <input type="password" id="password" name="password" required>
            </div>
            <button type="submit">ورود</button>
        </form>
    </div>
    </body>
    </html>
    <?php
    exit;
}

$storage = new JsonStorage($config['data_dir']);
$users = $storage->load('users');
if (!is_array($users)) {
    $users = [];
}
ksort($users);

$totalUsers = count($users);
?>
<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <title>داشبورد ربات تلگرام</title>
    <style>
        body { font-family: sans-serif; background-color: #f5f5f5; direction: rtl; }
        .container { max-width: 960px; margin: 40px auto; background: #fff; padding: 24px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); }
        table { width: 100%; border-collapse: collapse; margin-top: 16px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: right; }
        th { background-color: #f0f0f0; }
        .top-bar { display: flex; justify-content: space-between; align-items: center; margin-bottom: 16px; }
        .badge { background: #1976d2; color: #fff; padding: 4px 8px; border-radius: 4px; }
        form.logout { margin: 0; }
        button { padding: 6px 12px; }
    </style>
</head>
<body>
<div class="container">
    <div class="top-bar">
        <div>
            <strong>داشبورد ربات تلگرام</strong>
        </div>
        <div>
            <span class="badge">تعداد کاربران: <?php echo (int) $totalUsers; ?></span>
            <form method="post" class="logout" style="display:inline;">
                <input type="hidden" name="logout" value="1">
                <button type="submit">خروج</button>
            </form>
        </div>
    </div>

    <h2>لیست کاربران ثبت شده</h2>
    <table>
        <thead>
        <tr>
            <th>آیدی</th>
            <th>نام</th>
            <th>نام خانوادگی</th>
            <th>یوزرنیم</th>
            <th>زبان</th>
            <th>تاریخ ایجاد</th>
            <th>آخرین بروزرسانی</th>
        </tr>
        </thead>
        <tbody>
        <?php if ($totalUsers === 0): ?>
            <tr>
                <td colspan="7">هنوز کاربری ثبت نشده است.</td>
            </tr>
        <?php else: ?>
            <?php foreach ($users as $user): ?>
                <tr>
                    <td><?php echo htmlspecialchars((string) ($user['id'] ?? ''), ENT_QUOTES, 'UTF-8'); ?></td>
                    <td><?php echo htmlspecialchars((string) ($user['first_name'] ?? ''), ENT_QUOTES, 'UTF-8'); ?></td>
                    <td><?php echo htmlspecialchars((string) ($user['last_name'] ?? ''), ENT_QUOTES, 'UTF-8'); ?></td>
                    <td><?php echo htmlspecialchars((string) ($user['username'] ?? ''), ENT_QUOTES, 'UTF-8'); ?></td>
                    <td><?php echo htmlspecialchars((string) ($user['language_code'] ?? ''), ENT_QUOTES, 'UTF-8'); ?></td>
                    <td><?php echo htmlspecialchars((string) ($user['created_at'] ?? ''), ENT_QUOTES, 'UTF-8'); ?></td>
                    <td><?php echo htmlspecialchars((string) ($user['updated_at'] ?? ''), ENT_QUOTES, 'UTF-8'); ?></td>
                </tr>
            <?php endforeach; ?>
        <?php endif; ?>
        </tbody>
    </table>
</div>
</body>
</html>
