<?php

declare(strict_types=1);

namespace App\Modules;

use App\Bot\TelegramBot;

final class HelpModule extends BaseModule
{
    public function supports(string $command): bool
    {
        return $command === '/start' || $command === '/help';
    }

    public function handle(string $command, array $update, TelegramBot $bot): void
    {
        $message = $update['message'] ?? [];
        $from = $message['from'] ?? [];
        $chat = $message['chat'] ?? [];

        if (isset($from['id'])) {
            $bot->registerUser($from);
        }

        $chatId = $chat['id'] ?? null;
        if ($chatId === null) {
            return;
        }

        $config = $bot->getConfig();
        $adminIds = $config['admin_ids'] ?? [];

        $userId = isset($from['id']) ? (int) $from['id'] : null;
        $isAdmin = $userId !== null && in_array($userId, array_map('intval', $adminIds), true);

        $name = '';
        if (isset($from['first_name']) && $from['first_name'] !== '') {
            $name = (string) $from['first_name'];
        } elseif (isset($from['username']) && $from['username'] !== '') {
            $name = (string) $from['username'];
        }

        $params = [];

        if ($isAdmin) {
            $text = 'سلام ادمین عزیز';
            if ($name !== '') {
                $text .= ' ' . $name;
            }
            $text .= "\n";
            $text .= "شما به پنل مدیریتی ربات تریدینگ خودتان وارد شدید.\n";
            $text .= "در این نسخه، ربات در پس‌زمینه فعالیت کاربران و تاپیک‌ها را در دیتابیس ثبت می‌کند.\n";
            $text .= "به‌زودی منوهای مدیریتی کامل داخل همین چت اضافه می‌شود (داشبورد تاپیک‌ها، آمار هنرجویان و غیره).\n\n";
            $text .= "از دکمه‌های زیر برای مدیریت استفاده کن.";

            $params['reply_markup'] = [
                'inline_keyboard' => [
                    [
                        ['text' => '📊 داشبورد ادمین', 'callback_data' => 'admin:dashboard'],
                    ],
                    [
                        ['text' => '👥 مدیریت گروه‌ها', 'callback_data' => 'admin:groups'],
                    ],
                    [
                        ['text' => '👤 هنرجویان', 'callback_data' => 'admin:students'],
                    ],
                ],
            ];
        } else {
            $text = 'سلام';
            if ($name !== '') {
                $text .= ' ' . $name;
            }
            $text .= "\n";
            $text .= "به ربات آموزشی ترید خوش آمدی.\n";
            $text .= "فعلا این ربات برای هنرجویان گروه است و فعالیت شما را در تاپیک‌های گروه ثبت می‌کند تا منتور بتواند بهتر عملکرد را ارزیابی کند.\n";
            $text .= "به‌مرور امکانات بیشتری مثل گزارش عملکرد و سطح‌بندی هنرجویان اضافه می‌شود.";
        }

        $bot->getClient()->sendMessage((int) $chatId, $text, $params);
    }
}
